/* - IR full -
 * This example displays a gui that shows the attached Phidgets IR reader device's details and will
 * display and tag data that is scanned by the antenna.  it also provides checkboxes to manipulate the
 * different attirbutes of the IR reader as well as the digital outputs.
 *
 * Please note that this example was designed to work with only one Phidget IR connected.
 * For an example showing how to use two Phidgets of the same time concurrently, please see the
 * Servo-multi example in the Servo Examples.
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package IR;

import com.phidgets.IRCode;
import com.phidgets.IRCodeInfo;
import com.phidgets.IRPhidget;
import com.phidgets.PhidgetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

import listeners.*;

public class IR extends javax.swing.JFrame {

    private static String runArgs[];
    private IRPhidget ir;
    private IRAttachListener attach_listener;
    private IRDetachListener detach_listener;
    private IRErrorListener error_listener;
    private IRCodeListener code_listener;
    private IRLearnListener learn_listener;
    private IRRawDataListener rawData_listener;

    public IR() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        attachedTxt = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        nameTxt = new javax.swing.JTextArea();
        jLabel2 = new javax.swing.JLabel();
        serialTxt = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        versionTxt = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        codePanel = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        codeTxt = new javax.swing.JTextField();
        repeatCountTxt = new javax.swing.JTextField();
        bitLengthTxt = new javax.swing.JTextField();
        learnPanel = new javax.swing.JPanel();
        jlabelLearnIRCode = new javax.swing.JLabel();
        learnIRCodeTxt = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        jLabel12 = new javax.swing.JLabel();
        jLabel13 = new javax.swing.JLabel();
        jLabel14 = new javax.swing.JLabel();
        jLabel15 = new javax.swing.JLabel();
        jLabel16 = new javax.swing.JLabel();
        retransmitBtn = new javax.swing.JButton();
        learnBitLengthTxt = new javax.swing.JTextField();
        learnEncodingTxt = new javax.swing.JTextField();
        learnGapTxt = new javax.swing.JTextField();
        learnTrailTxt = new javax.swing.JTextField();
        learnZeroTxt = new javax.swing.JTextField();
        learnOneTxt = new javax.swing.JTextField();
        learnHeaderTxt = new javax.swing.JTextField();
        learnRepeatTxt = new javax.swing.JTextField();
        learnToggleMaskTxt = new javax.swing.JTextField();
        learnLengthTxt = new javax.swing.JTextField();
        rawDataPanel = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        rawDataArea = new javax.swing.JTextArea();
        rawDataAreaClearBtn = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosed(java.awt.event.WindowEvent evt) {
                formWindowClosed(evt);
            }
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });
        getContentPane().setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("IR Reciever Transmitter Info"));
        jPanel1.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        attachedTxt.setEditable(false);
        jPanel1.add(attachedTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 33, 200, -1));

        jLabel1.setText("Attached:");
        jPanel1.add(jLabel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(43, 36, -1, -1));

        nameTxt.setBackground(javax.swing.UIManager.getDefaults().getColor("TextField.disabledBackground"));
        nameTxt.setColumns(20);
        nameTxt.setEditable(false);
        nameTxt.setLineWrap(true);
        nameTxt.setRows(3);
        nameTxt.setTabSize(2);
        nameTxt.setWrapStyleWord(true);
        nameTxt.setPreferredSize(new java.awt.Dimension(200, 58));
        jScrollPane1.setViewportView(nameTxt);

        jPanel1.add(jScrollPane1, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 68, 200, -1));

        jLabel2.setText("Name:");
        jPanel1.add(jLabel2, new org.netbeans.lib.awtextra.AbsoluteConstraints(60, 68, -1, -1));

        serialTxt.setEditable(false);
        jPanel1.add(serialTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 144, 200, -1));

        jLabel3.setText("Serial No:");
        jPanel1.add(jLabel3, new org.netbeans.lib.awtextra.AbsoluteConstraints(41, 147, -1, -1));

        versionTxt.setEditable(false);
        jPanel1.add(versionTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 180, 200, -1));

        jLabel4.setText("Version:");
        jPanel1.add(jLabel4, new org.netbeans.lib.awtextra.AbsoluteConstraints(48, 180, -1, -1));

        getContentPane().add(jPanel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 0, 320, 217));

        codePanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Code"));
        codePanel.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jLabel5.setText("IR Code:");
        codePanel.add(jLabel5, new org.netbeans.lib.awtextra.AbsoluteConstraints(43, 36, -1, -1));

        jLabel6.setText("Bit Length:");
        codePanel.add(jLabel6, new org.netbeans.lib.awtextra.AbsoluteConstraints(35, 68, -1, -1));

        jLabel7.setText("Repeat Count:");
        codePanel.add(jLabel7, new org.netbeans.lib.awtextra.AbsoluteConstraints(161, 68, -1, -1));

        codeTxt.setEditable(false);
        codePanel.add(codeTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 33, 200, -1));

        repeatCountTxt.setEditable(false);
        codePanel.add(repeatCountTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(243, 65, 54, -1));

        bitLengthTxt.setEditable(false);
        codePanel.add(bitLengthTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 65, 54, -1));

        getContentPane().add(codePanel, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 220, 320, 100));

        learnPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Learn"));
        learnPanel.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jlabelLearnIRCode.setText("IR Code:");
        learnPanel.add(jlabelLearnIRCode, new org.netbeans.lib.awtextra.AbsoluteConstraints(44, 40, -1, -1));

        learnIRCodeTxt.setEditable(false);
        learnPanel.add(learnIRCodeTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 36, 200, -1));

        jLabel8.setText("Bit Length:");
        learnPanel.add(jLabel8, new org.netbeans.lib.awtextra.AbsoluteConstraints(34, 72, -1, -1));

        jLabel9.setText("Encoding:");
        learnPanel.add(jLabel9, new org.netbeans.lib.awtextra.AbsoluteConstraints(37, 101, -1, -1));

        jLabel10.setText("Gap:");
        learnPanel.add(jLabel10, new org.netbeans.lib.awtextra.AbsoluteConstraints(64, 133, -1, -1));

        jLabel11.setText("Trail:");
        learnPanel.add(jLabel11, new org.netbeans.lib.awtextra.AbsoluteConstraints(190, 133, -1, -1));

        jLabel12.setText("Zero:");
        learnPanel.add(jLabel12, new org.netbeans.lib.awtextra.AbsoluteConstraints(61, 165, -1, -1));

        jLabel13.setText("One:");
        learnPanel.add(jLabel13, new org.netbeans.lib.awtextra.AbsoluteConstraints(63, 197, -1, -1));

        jLabel14.setText("Header:");
        learnPanel.add(jLabel14, new org.netbeans.lib.awtextra.AbsoluteConstraints(49, 229, -1, -1));

        jLabel15.setText("Repeat:");
        learnPanel.add(jLabel15, new org.netbeans.lib.awtextra.AbsoluteConstraints(50, 261, -1, -1));

        jLabel16.setText("Toggle Mask:");
        learnPanel.add(jLabel16, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 294, -1, -1));

        retransmitBtn.setText("Re-Transmit");
        retransmitBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                retransmitBtnActionPerformed(evt);
            }
        });
        learnPanel.add(retransmitBtn, new org.netbeans.lib.awtextra.AbsoluteConstraints(193, 323, -1, -1));

        learnBitLengthTxt.setEditable(false);
        learnPanel.add(learnBitLengthTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 67, 200, -1));

        learnEncodingTxt.setEditable(false);
        learnPanel.add(learnEncodingTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 99, 100, -1));

        learnGapTxt.setEditable(false);
        learnPanel.add(learnGapTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 131, 70, -1));

        learnTrailTxt.setEditable(false);
        learnPanel.add(learnTrailTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(224, 131, 73, -1));

        learnZeroTxt.setEditable(false);
        learnPanel.add(learnZeroTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 163, 200, -1));

        learnOneTxt.setEditable(false);
        learnPanel.add(learnOneTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 195, 200, -1));

        learnHeaderTxt.setEditable(false);
        learnPanel.add(learnHeaderTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 227, 200, -1));

        learnRepeatTxt.setEditable(false);
        learnPanel.add(learnRepeatTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 259, 200, -1));

        learnToggleMaskTxt.setEditable(false);
        learnPanel.add(learnToggleMaskTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 291, 200, -1));

        learnLengthTxt.setEditable(false);
        learnLengthTxt.setBorder(null);
        learnPanel.add(learnLengthTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(200, 101, 90, -1));

        getContentPane().add(learnPanel, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 320, 320, 360));

        rawDataPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Raw Data"));
        rawDataPanel.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        rawDataArea.setColumns(20);
        rawDataArea.setEditable(false);
        rawDataArea.setLineWrap(true);
        rawDataArea.setRows(30);
        rawDataArea.setWrapStyleWord(true);
        rawDataArea.setMinimumSize(new java.awt.Dimension(4, 40));
        jScrollPane2.setViewportView(rawDataArea);

        rawDataPanel.add(jScrollPane2, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 30, 340, 600));

        rawDataAreaClearBtn.setText("Clear");
        rawDataAreaClearBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rawDataAreaClearBtnActionPerformed(evt);
            }
        });
        rawDataPanel.add(rawDataAreaClearBtn, new org.netbeans.lib.awtextra.AbsoluteConstraints(296, 643, -1, -1));

        getContentPane().add(rawDataPanel, new org.netbeans.lib.awtextra.AbsoluteConstraints(340, 0, 380, 680));

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened

         this.setSize(357, 260);
         codePanel.setEnabled(false);
         codePanel.setVisible(false);

        learnPanel.setEnabled(false);
        learnPanel.setVisible(false);

        rawDataPanel.setEnabled(false);
        rawDataPanel.setVisible(false);

        retransmitBtn.setEnabled(false);

        try {
            ir = new IRPhidget();

            attach_listener = new IRAttachListener(this, this.codePanel, this.learnPanel, this.rawDataPanel, this.attachedTxt, this.nameTxt,
                    this.serialTxt, this.versionTxt);

            detach_listener = new IRDetachListener(this, this.codePanel, this.learnPanel, this.rawDataPanel, this.attachedTxt, this.nameTxt,
                    this.serialTxt, this.versionTxt, this.codeTxt, this.bitLengthTxt, this.repeatCountTxt, this.learnIRCodeTxt,
                    this.learnBitLengthTxt, this.learnEncodingTxt, this.learnLengthTxt, this.learnGapTxt, this.learnTrailTxt, this.learnZeroTxt, this.learnOneTxt, this.learnHeaderTxt,
                    this.learnRepeatTxt, this.learnToggleMaskTxt, this.retransmitBtn, this.rawDataArea);

            error_listener = new IRErrorListener(this);

            code_listener = new IRCodeListener(this, this.codeTxt, this.bitLengthTxt, this.repeatCountTxt);

            learn_listener = new IRLearnListener(this, this.learnIRCodeTxt, this.learnBitLengthTxt, this.learnEncodingTxt, this.learnLengthTxt,
                    this.learnGapTxt, this.learnTrailTxt, this.learnZeroTxt, this.learnOneTxt, this.learnHeaderTxt,
                    this.learnRepeatTxt, this.learnToggleMaskTxt, this.retransmitBtn);

            rawData_listener = new IRRawDataListener(this, this.rawDataArea);

            ir.addAttachListener(attach_listener);
            ir.addDetachListener(detach_listener);
            ir.addErrorListener(error_listener);
            ir.addCodeListener(code_listener);
            ir.addLearnListener(learn_listener);
            ir.addRawDataListener(rawData_listener);
            
            //This assumes that if there is a command line argument, it is a serial number
            //and we try to open that specific device. Otherwise, open any device.
            if ((runArgs.length > 1) && (runArgs[1].equals("remote"))) {
                ir.open(Integer.parseInt(runArgs[0]), null);
            }
            if (runArgs.length > 0) {
                ir.open(Integer.parseInt(runArgs[0]));
            } else {
                ir.openAny();

            }

        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }

    }//GEN-LAST:event_formWindowOpened

    private void retransmitBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_retransmitBtnActionPerformed
        try {
           IRCode lastLearnedCode=ir.getLastLearnedCode().getCode();
           IRCodeInfo lastLearnedCodeInfo=ir.getLastLearnedCode().getCodeInfo();
           ir.transmit(lastLearnedCode, lastLearnedCodeInfo);
        } catch (PhidgetException ex) {
               Logger.getLogger(IR.class.getName()).log(Level.SEVERE, null, ex);
        }
        
    }//GEN-LAST:event_retransmitBtnActionPerformed

    private void rawDataAreaClearBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rawDataAreaClearBtnActionPerformed
        rawDataArea.setText(null);
    }//GEN-LAST:event_rawDataAreaClearBtnActionPerformed

    private void formWindowClosed(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosed
        try
        {
            //unhook the event listeners
            ir.removeCodeListener(code_listener);
            ir.removeLearnListener(learn_listener);
            ir.removeRawDataListener(rawData_listener);

            ir.removeErrorListener(error_listener);
            ir.removeDetachListener(detach_listener);
            ir.removeAttachListener(attach_listener);

            //close the phidget
            ir.close();

            ir = null;

            dispose();
            System.exit(0);
        }
        catch(PhidgetException ex)
        {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            dispose();
            System.exit(0);
        }
    }//GEN-LAST:event_formWindowClosed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        runArgs = args;
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new IR().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField attachedTxt;
    private javax.swing.JTextField bitLengthTxt;
    private javax.swing.JPanel codePanel;
    private javax.swing.JTextField codeTxt;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JLabel jlabelLearnIRCode;
    private javax.swing.JTextField learnBitLengthTxt;
    private javax.swing.JTextField learnEncodingTxt;
    private javax.swing.JTextField learnGapTxt;
    private javax.swing.JTextField learnHeaderTxt;
    private javax.swing.JTextField learnIRCodeTxt;
    private javax.swing.JTextField learnLengthTxt;
    private javax.swing.JTextField learnOneTxt;
    private javax.swing.JPanel learnPanel;
    private javax.swing.JTextField learnRepeatTxt;
    private javax.swing.JTextField learnToggleMaskTxt;
    private javax.swing.JTextField learnTrailTxt;
    private javax.swing.JTextField learnZeroTxt;
    private javax.swing.JTextArea nameTxt;
    private javax.swing.JTextArea rawDataArea;
    private javax.swing.JButton rawDataAreaClearBtn;
    private javax.swing.JPanel rawDataPanel;
    private javax.swing.JTextField repeatCountTxt;
    private javax.swing.JButton retransmitBtn;
    private javax.swing.JTextField serialTxt;
    private javax.swing.JTextField versionTxt;
    // End of variables declaration//GEN-END:variables
}
